/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package datasource;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class DataSourceFactory {

    public DataSource getDataSource() {
        return new FileDataSource();
    }

    public DataSource getDataSourceFrom(String name) {
        if (name.equals("File")) {
            return new FileDataSource();
        } else if (name.equals("Memory")) {
            return new InMemoryDataSource();
        } else {
            return null;
        }
    }
}
